from abc import ABC, abstractmethod

from scripts.core.handlers.player_names import LeftFootDefender, LeftFootMidfielder, LeftFootStriker, RightFootDefender, \
    RightFootMidfielder, RightFootStriker


class PlayerFactory(ABC):
    @abstractmethod
    def create_defender(self):
        pass

    @abstractmethod
    def create_midfielder(self):
        pass

    @abstractmethod
    def create_striker(self):
        pass


class LeftFootPlayerFactory(PlayerFactory):
    def create_defender(self):
        return LeftFootDefender()

    def create_midfielder(self):
        return LeftFootMidfielder()

    def create_striker(self):
        return LeftFootStriker()


class RightFootPlayerFactory(PlayerFactory):
    def create_defender(self):
        return RightFootDefender()

    def create_midfielder(self):
        return RightFootMidfielder()

    def create_striker(self):
        return RightFootStriker()
