import json

from script.config.appconfig import mqtt_topic
from script.core.handlers.publishing import mqtt_consume
from script.core.handlers.storeToRedis import store_redis


def subscribe(client):
    def on_message(client, userdata, msg):
        data_received = json.loads(msg.payload.decode())
        print(data_received)
        store_redis(data_received)

    client.subscribe(mqtt_topic)
    client.on_message = on_message


def run():
    try:
        client = mqtt_consume()
        subscribe(client)
        client.loop_forever()
    except KeyboardInterrupt:
        client.loop_stop()
