import json
from script.utils.redisConnection import r1, r2, r3


def store_redis(data_received):
    quality = data_received["data_quality"]
    print(quality)
    data_to_store = data_received["data"]
    key = data_received["site_id"]
    mapper = {0: QualityInsert.good,
              1: QualityInsert.maintenance,
              2: QualityInsert.error}
    mapper.get(quality)(key, data_to_store)


class QualityInsert:
    @staticmethod
    def good(key, data):
        r1.set(key, json.dumps(data))

    @staticmethod
    def maintenance(key, data):
        r2.set(key, json.dumps(data))

    @staticmethod
    def error(key, data):
        r3.set(key, json.dumps(data))
