from fastapi import FastAPI

from script.config.appconfig import post_end
from script.core.handlers.publishing import mqtt_publish
from script.database.basemodel import DataModel

app = FastAPI()


@app.post(post_end)
async def get_data(data: DataModel, site_id: str, data_quality: int):
    data_format = {"data": data, "site_id": site_id, "data_quality": data_quality}
    response = mqtt_publish(data_format)
    return response
