import json

from pydantic import BaseModel


class DataModel(BaseModel):
    PM10: int
    PM2_5: int
    SO2: int
    NO2: int


class DataEncoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, DataModel):
            return obj.dict()
        return super().default(obj)
