import logging
import os
from logging.handlers import RotatingFileHandler


def get_logger():
    # creating rotating logging
    __logger__ = logging.getLogger('')
    __logger__.setLevel(logging.INFO)
    file_path = "script/logging/"
    formatter = logging.Formatter('%(asctime)s - %(levelname)-6s - %(message)s', "%Y-%m-%d %H:%M:%S")
    log_file = os.path.join(f"{file_path}exceptions.log")
    temp_handler = RotatingFileHandler(log_file, maxBytes=1, backupCount=10)
    temp_handler.setFormatter(formatter)
    __logger__.addHandler(temp_handler)

    return __logger__


logger = get_logger()