import copy

import httpx

from scripts.config import Base_path, Project_details
from scripts.constants.api import RequestEndpoints
from scripts.constants.json_constants import site_level_hierarchy_payload, hierarchy_payload
from scripts.constants.request_payloads import cookies, DashboardPayloads
from scripts.logging.logger import logger
from scripts.utils.dashboard_utils import create_hierarchy

dashboard_payloads = DashboardPayloads()


class Widgets:
    @staticmethod
    def get_widget_details(existing_dashboard):
        try:
            logger.info(f'service started in getting the widget data')
            list_widgets_url = f'{Base_path.BASE_URL}{RequestEndpoints.list_widgets}'
            list_widgets_payload = dashboard_payloads.list_widgets
            list_widgets_payload["project_id"] = Project_details.PROJECT_ID
            list_widgets_payload["dashboard_id"] = existing_dashboard["dashboard_id"]
            list_widgets_payload["name"] = existing_dashboard["name"]
            widgets_details = httpx.post(url=list_widgets_url, cookies=cookies, json=list_widgets_payload)
            widgets_details_json = widgets_details.json()
            existing_widgets = widgets_details_json.get("data")
            if widgets_details.status_code != 200 or not existing_widgets:
                return False
            return existing_widgets
        except Exception as e:
            logger.error(f'error while getting existing widget details {e}')

    @staticmethod
    def create_new_widgets(existing_widget, parameters_json, dashboard_id):
        try:
            logger.info(f'service started in creating new widgets')
            count = 0
            error_widgets = []
            existing_widget_details = existing_widget.get("widget").get("wcData")
            group_elements = [elem for elem in existing_widget_details if
                              elem.get('cData', {}).get('chartOptions', {}).get('chartType') == 'group']
            if group_elements:
                existing_widget_details = [elem for elem in existing_widget_details if elem not in group_elements]
            existing_widget_details.extend(group_elements)
            for widget in existing_widget_details:
                new_widget_metadata, missing_tags = Widgets().create_pyload(widget, parameters_json)
                widget_payload = {
                    "dashboard_id": dashboard_id,
                    "widget_data": new_widget_metadata,
                    "project_id": Project_details.PROJECT_ID,
                    "project_type": "customer",
                    "tz": "Asia/Kolkata",
                    "language": "en"
                }

                save_widget_url = f'{Base_path.BASE_URL}{RequestEndpoints.save_widget}'
                save_widget_response = httpx.post(url=save_widget_url, cookies=cookies, json=widget_payload)
                count += 1
                if save_widget_response.status_code != 200:
                    error_widgets.append(count)
            return error_widgets, missing_tags
        except Exception as e:
            logger.error(f'error while creating new widgets {e}')

    @staticmethod
    def create_pyload(widget, parameters_json):
        try:
            count = 0
            logger.info(f'service started in creating payload')
            filter_payload = []
            new_yaxis_data = []
            new_filter_parameters = []
            missing_tags = []
            new_widget_payload = widget
            # filter_list_old = new_widget_payload["cData"]["chartOptions"]["filter"]["filterList"][0]["value"]
            new_widget_payload.pop('widget_id')
            if widget["cData"]["chartOptions"]["chartType"] == "group":
                Widgets().get_group_widget(widget, parameters_json)
            else:
                if new_widget_payload.get("editMode"):
                    new_widget_payload.pop('editMode')
                hierarchy_data, filter_data = create_hierarchy(parameters_json)
                yaxis_parameters = widget["cData"]["chartOptions"]["yaxis"]
                hierarchy_details_url = f'{Base_path.BASE_URL}{RequestEndpoints.hierarchy_details}'
                hierarchy_payload_ = hierarchy_payload
                hierarchy_payload_["project_id"] = Project_details.PROJECT_ID
                hierarchy_details = httpx.post(url=hierarchy_details_url, cookies=cookies, json=hierarchy_payload_,
                                               timeout=120)
                hierarchy_details_json = hierarchy_details.json()
                hierarchy_details_list = hierarchy_details_json["data"]
                site_level_hierarchy_url = f'{Base_path.NEW_BASE_URL}{RequestEndpoints.get_site_level_hierarchy}'
                payload_site_level = site_level_hierarchy_payload
                payload_site_level["project_id"] = Project_details.PROJECT_ID
                payload_site_level["tz"] = "Asia/Kolkata"
                site_level_hierarchy = httpx.post(url=site_level_hierarchy_url, cookies=cookies,
                                                  json=payload_site_level, timeout=120)
                widget_title = ''
                if site_level_hierarchy.status_code == 200:
                    site_level_hierarchy_json = site_level_hierarchy.json()
                    site_level_hierarchy_data = site_level_hierarchy_json["site_hierarchy_data"]
                    current_site_level = {}
                    for select_hierarchy in filter_data:
                        for data_ in site_level_hierarchy_data:
                            if data_["name"] == select_hierarchy["filter"] and select_hierarchy["Existing Widget Name"] == \
                                    widget["title"]:
                                widget_title = select_hierarchy["New widget Name"]
                                current_site_level = data_
                                current_site_level["label"] = current_site_level["name"]
                                current_site_level["value"] = current_site_level["id"]
                                current_site_level["disabled"] = False
                                current_site_level["checked"] = True
                                filter_payload.append(current_site_level)

                new_widget_payload["cData"]["chartOptions"]["filter"]["filterList"][0]["value"] = filter_payload
                new_widget_payload["cData"]["chartOptions"]["filter"]["filtersData"][0]["value"] = filter_payload
                """tested till here"""
                for tags in hierarchy_details_list:
                    flag = 0
                    for data in yaxis_parameters:
                        for tag_name in hierarchy_data:
                            if tag_name.get("Tag Name", "") == tags["label"] and tag_name["Existing Widget Name"] == widget[
                                "title"]:
                                count += 1
                                print(count)
                                current_tag = tags
                                disable = data["tag"].get("disabled", True)
                                data["tag"] = current_tag
                                data["tag"]["disabled"] = disable
                                data["name"] = tag_name["Label"]
                                data["unitInfo"] = current_tag['unit']
                                data["unit"] = current_tag['unit']['label']
                                flag = 1
                                new_yaxis_data.append(copy.deepcopy(data))
                        if flag:
                            break

                if widget["cData"]["chartOptions"].get("wSettings", ""):
                    dynamic_yaxis = widget["cData"]["chartOptions"]["yaxis"]
                    for data in dynamic_yaxis:
                        label = data["tag"]["label"]
                        for tag in hierarchy_details_list:
                            parameter_data = tag["label"].split(':')
                            tag_label = parameter_data[-1]
                            if label == tag_label:
                                tag_value = tag["value"]
                                split_value = tag_value.split('$')
                                parameter_value = split_value[-1]
                                data["tag"]["value"] = parameter_value
                                new_yaxis_data.append(data)
                    filter_parameters = widget["cData"]["chartOptions"]["filterParameters"]
                    for data in filter_parameters:
                        label = data["tag"]["label"]
                        for tag in hierarchy_details_list:
                            parameter_data = tag["label"].split(':')
                            tag_label = parameter_data[-1]
                            if label == tag_label:
                                tag_value = tag["value"]
                                split_value = tag_value.split('$')
                                parameter_value = split_value[-1]
                                data["tag"]["value"] = parameter_value
                                new_filter_parameters.append(data)
                    new_widget_payload["cData"]["chartOptions"]["filterParameters"] = new_filter_parameters
            new_widget_payload["title"] = widget_title
            new_widget_payload["description"] = widget_title
            new_widget_payload["cData"]["chartOptions"]["yaxis"] = new_yaxis_data
            x_axis_data = widget["cData"]["chartOptions"]["xaxis"]
            aggregation_parameters = []
            if x_axis_data["aggregations"]:
                xaxis_aggregations = x_axis_data["aggregations"]
                for parameters in xaxis_aggregations:
                    if parameters["parameters"]:
                        aggregation_parameters = parameters["parameters"]
            if aggregation_parameters:
                # old
                hierarchy_details_url_old = f'{Base_path.BASE_URL}{RequestEndpoints.hierarchy_details}'
                old_env_cookie = {
                    "login-token": Project_details.LOGIN_TOKEN,
                    "userId": Project_details.USER_ID,
                    "projectId": Project_details.PROJECT_ID
                }
                hierarchy_payload_old = hierarchy_payload.copy()
                hierarchy_payload_old["project_id"] = Project_details.PROJECT_ID
                hierarchy_details_old = httpx.post(url=hierarchy_details_url_old, cookies=old_env_cookie,
                                                   json=hierarchy_payload_old, timeout=80)
                hierarchy_details_json_old = hierarchy_details_old.json()
                hierarchy_details_list_old = hierarchy_details_json_old["data"]
                new_parameters = []
                params_label = []
                changed_params_label = []
                for params in aggregation_parameters:
                    for tags in hierarchy_details_list_old:
                        if params == tags["value"]:
                            params_label.append(tags["label"])
                # for label in params_label:
                #     if label in filtered_hierarchy_data:
                #         changed_params_label.append(filtered_hierarchy_data[label])
                if changed_params_label:
                    for changed_label in changed_params_label:
                        for tags in hierarchy_details_list:
                            if changed_label == tags["label"]:
                                new_parameters.append(tags["value"])
                new_widget_payload["cData"]["chartOptions"]["xaxis"]["aggregations"][0]["parameters"] = new_parameters
            return new_widget_payload, missing_tags
        except Exception as e:
            logger.error(f'error while creating payload {e}')
            pass

    @staticmethod
    def get_group_widget(widget, parameters_json):
        logger.info(f'service started in creating group widget')
        for data in parameters_json:
            if data["Tag Name"] == "Group Widget":
                print("tbd")
        widget["cData"]["widgetsList"] = "list"
