import httpx

from scripts.config import Project_details, Base_path
from scripts.constants.api import RequestEndpoints
from scripts.constants.json_constants import list_dashboard_payload
from scripts.constants.request_payloads import cookies
from scripts.logging.logger import logger


class Dashboards:
    @staticmethod
    def get_dashboard_details(dashboard_name):
        try:
            logger.info(f'service started in getting the dashboard reference')
            existing_dashboard = list_dashboard_payload
            existing_dashboard["searchText"] = dashboard_name["dashboard_name"]
            existing_dashboard["filters"]["search"] = dashboard_name["dashboard_name"]
            existing_dashboard["project_id"] = Project_details.PROJECT_ID
            list_url = f'{Base_path.BASE_URL}{RequestEndpoints.list_dashboards}'
            dashboard_lists = httpx.post(url=list_url, cookies=cookies, json=list_dashboard_payload)
            json_response = dashboard_lists.json()
            list_of_dashboards = json_response["data"]["body_content"]
            if dashboard_lists.status_code != 200:
                return False
            dashboard_details = {}
            for item in list_of_dashboards:
                if item.get('name') == dashboard_name["dashboard_name"]:
                    dashboard_details = item
            return dashboard_details
        except Exception as e:
            logger.exception(f'error while fetching the dashboard details {e}')

    @staticmethod
    def create_new_dashboard(existing_dashboard, new_dashboard_name):
        try:
            """tested until this"""
            logger.info(f'service started in creating new dashboard')
            category = existing_dashboard["category"]
            dashboard_type = existing_dashboard["type"]
            dashboard_name = new_dashboard_name
            list_of_dashboards = Dashboards().get_dashboard_details({"dashboard_name": dashboard_name})
            # for data in list_of_dashboards:
            if list_of_dashboards.get('name') == new_dashboard_name:
                dashboard_name = f'{new_dashboard_name}_new'
            Dashboards().create_dashboard(dashboard_name, category, dashboard_type)
            new_dashboard_list = Dashboards().get_dashboard_details({"dashboard_name": dashboard_name})
            dashboard_id = ""
            # for data in new_dashboard_list:
            if new_dashboard_list.get('name') == dashboard_name:
                dashboard_id = new_dashboard_list.get('dashboard_id', '')
            logger.info(f'dashboard id >>>> {dashboard_id}')
            if dashboard_id:
                return dashboard_id
            else:
                return False
        except Exception as e:
            logger.error(f'error while creating new dashboard {e}')

    @staticmethod
    def create_dashboard(dashboard_data, category, dashboard_type):
        try:
            logger.debug(f'creating json payload')
            payload = {
                "category": category,
                "name": dashboard_data,
                "project_id": Project_details.PROJECT_ID,
                "type": dashboard_type,
                "project_type": "customer",
                "tz": "Asia/Kolkata",
                "language": "en"
            }
            url = f'{Base_path.BASE_URL}{RequestEndpoints.save_dashboard}'
            response = httpx.post(url=url, cookies=cookies, json=payload)
            return response
        except Exception as e:
            logger.error(f'error in create dashboard {e}')
