import json

import httpx
from tzlocal import get_localzone

from scripts.config import Base_path, Project_details
from scripts.constants.api import RequestEndpoints
from scripts.constants.keys import KeyConstants
from scripts.logging.logger import logger


def get_local_timezone():
    local_timezone = get_localzone()
    return local_timezone


def get_dashboards_list(list_dashboard_payload, cookies):
    if not cookies:
        cookies = {
            "login-token": Project_details.LOGIN_TOKEN, "userId": Project_details.USER_ID,
            "projectId": Project_details.PROJECT_ID
        }
    list_url = f'{Base_path.BASE_URL}{RequestEndpoints.list_dashboards}'
    dashboard_lists = httpx.post(url=list_url, cookies=cookies, json=list_dashboard_payload)
    json_response = dashboard_lists.json()
    list_of_dashboards = json_response["data"]["body_content"]
    return list_of_dashboards


def get_hierarchy(data):
    combination_dict = {}
    filter_dict = {}
    for doc in data:
        widget_type_key = f"{doc['widget_name']}_{doc['type']}"
        filter_combination = f"{doc['site']}>"
        combination = f"{doc['site']}>"
        filter_combination += f"{doc['plant']}>" if doc['plant'] else ""
        combination += f"{doc['plant']}>" if doc['plant'] else ""
        filter_combination += f"{doc['line']}>" if doc['line'] else ""
        combination += f"{doc['line']}>" if doc['line'] else ""
        filter_combination += f"{doc['equipment']}" if doc['equipment'] else ""
        combination += f"{doc['equipment']}:" if doc['equipment'] else ""
        combination += f"{doc['parameters']}" if doc['parameters'] else ""

        # Check if the combination is already present
        if widget_type_key in combination_dict:
            combination_dict[widget_type_key].append(combination)
        else:
            combination_dict[widget_type_key] = [combination]
        if widget_type_key not in filter_dict:
            filter_dict[widget_type_key] = [filter_combination]
        else:
            if filter_combination not in filter_dict[widget_type_key]:
                filter_dict[widget_type_key].append(filter_combination)
    return combination_dict, filter_dict


def create_hierarchy(json_data):
    combination_list = []
    filter_list = []
    for data in json_data:
        filter_data = data["Tag Name"].split(":")[0]
        data["filter"] = filter_data
        filter_list.append(data)
        combination_list.append(data)
    return combination_list, filter_list


def get_new_dashboards_list(list_dashboard_payload, cookies):
    list_url = f'{Base_path.NEW_BASE_URL}{RequestEndpoints.list_dashboards}'
    dashboard_lists = httpx.post(url=list_url, cookies=cookies, json=list_dashboard_payload)
    json_response = dashboard_lists.json()
    list_of_dashboards = json_response["data"]["body_content"]
    return list_of_dashboards


def create_json(df):
    try:
        logger.debug(f'creating json')
        data_dict = df.to_dict(orient='split')
        keys = data_dict['columns']
        values = data_dict['data']
        json_data = [dict(zip(keys, v)) for v in values]
        with open(KeyConstants.output_file, 'w') as f:
            json.dump(json_data, f)
        return json_data
    except Exception as e:
        logger.error(f'error while creating json {e}')
