from pydantic import Field
from pydantic_settings import BaseSettings
from dotenv import load_dotenv

load_dotenv()


class _Services(BaseSettings):
    SERVICE_HOST: str = Field(default="127.0.0.1", env="service_host")
    SERVICE_PORT: int = Field(default=8001, env="service_port")
    PROJECT_NAME: str = Field(default="EMS-Automation", env="project_name")
    ENABLE_CORS: bool = True
    CORS_ALLOW_CREDENTIALS: bool = True
    CORS_ALLOW_METHODS: list = ["GET", "POST"]
    CORS_ALLOW_HEADERS: list = ["*"]
    LOG_LEVEL: str
    BACKUP_COUNT: int
    MAX_BYTES: int
    ENABLE_FILE_LOGGING: bool = True
    ENABLE_BACKUP_STORING: bool = Field(default=False, env="enable_backup")
    WORKERS: int = Field(default=12, env="workers")


class _BasePathConf(BaseSettings):
    BASE_URL: str = Field(default="http://192.168.0.220/", env="base_path")
    NEW_BASE_URL: str = Field(default="http://192.168.0.220/", env="new_base_url")


class _PathConf(BaseSettings):
    LOG_PATH: str
    CONFIG_PATH: str


class _Databases(BaseSettings):
    MONGO_URI: str = Field(default="mongodb://localhost:27017", env="mongo_uri")
    # DB_ASSET_CONSTANTS: str = Field(default="Asset_manager_constants", env="db_asset_constants")
    DB_NAME: str = Field(default="ilens_widget", env="db_name")


class _ProjectDetails(BaseSettings):
    USER_ID: str = Field(default="user_099", env="user_id")
    PROJECT_ID: str = Field(default="project_099", env="project_id")
    LOGIN_TOKEN: str = Field(default="0224903f578741f1a092679365f371d8", env="login_token")
    NEW_USER_ID: str = Field(default="user_099", env="new_user_id")
    NEW_PROJECT_ID: str = Field(default="project_099", env="new_project_id")
    NEW_LOGIN_TOKEN: str = Field(default="1e0fe69ec4f6473da8444f2d8cc54d81", env="new_login_token")


Services = _Services()
PathConf = _PathConf()
Databases = _Databases()
Base_path = _BasePathConf()
Project_details = _ProjectDetails()

__all__ = [
    "Services",
    "PathConf",
    "Databases",
    "Base_path",
    "Project_details"
]
