import logging
import uvicorn
from fastapi import FastAPI

app = FastAPI()

@app.get("/forecast")
def forecast():
    with httpx.Client() as client:
        response = client.get('https://api.open-meteo.com/v1/forecast?latitude=52.52&longitude=13.41&current_weather=true&hourly=temperature_2m,relativehumidity_2m,windspeed_10m')
        if response.status_code == 200:
            data = response.json()
            return data
        else:
            return {"message": f"Request failed with status code: {response.status_code}", "status":"failed"}

if __name__ == "__main__":
    bind = "0.0.0.0"  # Change this to your desired bind address (e.g., "127.0.0.1")
    port = 8000      # Change this to your desired port number
    logging.info(f"App Starting at {bind}:{port}")
    uvicorn.run("main:app", host=bind, port=port)
