if __name__ == '__main__':
    from dotenv import load_dotenv

    load_dotenv()
import os
import sys
from configparser import BasicInterpolation, ConfigParser


class EnvInterpolation(BasicInterpolation):
    """
    Interpolation which expands environment variables in values.
    """

    def before_get(self, parser, section, option, value, defaults):
        value = super().before_get(parser, section, option, value, defaults)

        if not os.path.expandvars(value).startswith('$'):
            return os.path.expandvars(value)
        else:
            return


try:
    config = ConfigParser(interpolation=EnvInterpolation())
    config.read(f"conf/application.conf")
except Exception as e:
    print(f"Error while loading the config: {e}")
    print("Failed to Load Configuration. Exiting!!!")
    sys.stdout.flush()
    sys.exit()


class PathToStorage:
    BASE_PATH = config.get("PATH", "base_path")
    if not BASE_PATH:
        print("Error, environment variable BASE_PATH not set")
        sys.exit(1)
    MOUNT_DIR = config.get("PATH", "mount_dir")
    if not MOUNT_DIR:
        print("Error, environment variable MOUNT_DIR not set")
        sys.exit(1)
    LOGS_MODULE_PATH = f"{BASE_PATH}/logs{MOUNT_DIR}/"


class Service:
    host = config.get("SERVICE", "host")
    port = config.getint("SERVICE", "port")
    enable_security = config.getboolean("SERVICE", "enable_security")
    allow_cross_origin = config.getboolean("SERVICE", "allow_cross_origin")
    secure_cookie = config.getboolean("SERVICE", "secure_cookie", fallback=True)


class Mongo:
    uri = config.get("MONGO_DB", "uri")


class SchedulerConf:
    scheduler_thread = config.get("SCHEDULER", "SCHEDULER_THREAD")
    scheduler_thread = 120 if not scheduler_thread else int(scheduler_thread)

    scheduler_process = config.get("SCHEDULER", "SCHEDULER_PROCESS")
    scheduler_process = 5 if not scheduler_process else int(scheduler_process)

    max_instance = config.get("SCHEDULER", "MAX_INSTANCE")
    max_instance = 50 if not max_instance else int(max_instance)
    misfire_grace_time_in_s = config.getint("SCHEDULER", "MISFIRE_SEC", fallback=3)


class KeyPath(object):
    public = os.path.join("assets", "keys", "public")
    private = os.path.join("assets", "keys", "private")


#  Redis Details
redis_section = "REDIS"
redis_uri = config[redis_section]["REDIS_URI"]
redis_login_db = int(config[redis_section]["login_db"])
user_role_permissions = config[redis_section]["user_role_permissions"]
project_tags_db = config[redis_section]["project_tags_db"]
