import time
from typing import Dict, Optional, List, Any, Union

from pydantic import BaseModel


class IntervalSettings(BaseModel):
    # One time
    trigger_date_time: int = int(time.time() * 1000)

    # Recurring
    # # Every n minutes
    from_date: int = int(time.time() * 1000)
    to_date: int = int(time.time() * 1000)
    daily_start_time: Optional[int]
    daily_end_time: Optional[int]
    configure_daily_time_range: Optional[bool] = False

    minute: Optional[int]

    # # Every n hour
    hour: Optional[int]

    # # Daily
    selected_interval: Optional[str]
    trigger_time: Optional[int]

    # # Weekly
    selected_week_days: Optional[List]

    # # Monthly
    selected_months: Optional[List]
    date_enabled: Optional[bool] = True
    days_enabled: Optional[bool] = False
    selected_date: Optional[str]
    run_on_day: Optional[str]
    run_on_occurrence: Optional[str]


class APIProperties(BaseModel):
    api_url: str
    api_method: str
    payload: Optional[Dict]


class FunctionProperties(BaseModel):
    class_name: str
    func_name: str
    args: Optional[Any]
    kwargs: Optional[Dict]


class JobDetails(BaseModel):
    execution_method: str
    execution_properties: Optional[Union[APIProperties, FunctionProperties]]


class ScheduleProperties(BaseModel):
    trigger_type: str = "onetime"
    trigger_interval: str
    interval_properties: IntervalSettings


class ScheduleMetadata(BaseModel):
    created_on: int = int(time.time() * 1000)
    created_by: str
    last_updated: int = int(time.time() * 1000)
    last_updated_by: str
    desc: str


class ScheduleJobRequest(BaseModel):
    user_id: Optional[str] = "system"
    schedule_properties: Optional[ScheduleProperties]
    job_details: Optional[JobDetails]
    job_type: str
    scheduler_type: str = "server"
    project_id: str
    hierarchy: Optional[str]
    schedule_id: str = None
    advanced_schedule_properties:Optional[Dict]
    schedule_type: Optional[str]


class SchedulesFetchRequest(BaseModel):
    filters: Optional[Dict]


class ScheduledIDFetchRequest(SchedulesFetchRequest):
    pass
