from scripts.constants.app_constants import DatabaseConstants, CommonKeys
from scripts.constants.db_connection import mongo_util
from scripts.logging.logging import logger
from scripts.utils.mongo_util import MongoCollectionClass


class ScheduleMetadataCollection(MongoCollectionClass):
    def __init__(self):
        self.database = DatabaseConstants.db_ilens_configuration
        self.collection = DatabaseConstants.collection_scheduled_metadata

    @property
    def key_schedule_id(self):
        return CommonKeys.schedule_id

    def get_schedule_id(self, filters):
        try:
            data = mongo_util.find_one(
                database_name=self.database,
                collection_name=self.collection,
                query=filters,
                filter_dict={
                    self.key_schedule_id: 1,
                    self.key_mongo_default_id: 0,
                },
            )
            return data
        except Exception as e:
            logger.exception(e)
            raise

    def get_all_schedules(self, filters):
        try:
            data = mongo_util.find(
                database_name=self.database,
                collection_name=self.collection,
                query=filters,
            )
            return data
        except Exception as e:
            logger.exception(e)
            raise

    def get_schedule_details(self, schedule_id):
        try:
            query = {self.key_schedule_id: schedule_id}
            data = mongo_util.find_one(
                database_name=self.database,
                collection_name=self.collection,
                query=query,
            )
            return data
        except Exception as e:
            logger.exception(e)
            raise

    def delete_schedule(self, schedule_id):
        try:
            query = {self.key_schedule_id: schedule_id}
            data = mongo_util.delete_one(
                database_name=self.database,
                collection_name=self.collection,
                query=query,
            )
            return data
        except Exception as e:
            logger.exception(e)
            raise
