from apscheduler.executors.pool import ProcessPoolExecutor, ThreadPoolExecutor
from apscheduler.jobstores.mongodb import MongoDBJobStore
from apscheduler.schedulers.background import BackgroundScheduler
from pytz import utc

from scripts.constants.app_configuration import Mongo, SchedulerConf
from scripts.constants.app_constants import DatabaseConstants
from scripts.logging.logging import logger

database_name = DatabaseConstants.db_ilens_configuration
collection = DatabaseConstants.collection_scheduled_jobs

job_store = {
    "default": MongoDBJobStore(
        database=database_name,
        collection=collection,
        host=Mongo.uri,
        connect=False,
    )
}

executors = {
    "default": ThreadPoolExecutor(SchedulerConf.scheduler_thread),
    "processpool": ProcessPoolExecutor(SchedulerConf.scheduler_process),
}
job_defaults = {"coalesce": False, "misfire_grace_time": SchedulerConf.misfire_grace_time_in_s, "max_instances": SchedulerConf.max_instance}
logger.info("Scheduler Initialising")
scheduler = BackgroundScheduler(
    jobstores=job_store,
    executors=executors,
    job_defaults=job_defaults,
    timezone=utc,
    daemon=True,
)
logger.info("Scheduler Initialised")
