class APIEndpoints:
    # scheduler APIs
    scheduler_base = "/scheduler"
    schedule = "/schedule"
    delete_schedule = "/delete"
    fetch_schedule_id = "/fetch/schedule_id"
    fetch_schedules = "/fetch/all_schedules"
    fetch_schedule_details = "/fetch/schedule_details"
    fetch_schedule_details_table = "/fetch/schedule_details_table"


class DatabaseConstants:
    db_ilens_configuration = "ilens_configuration"
    collection_scheduled_metadata = "schedule_metadata"
    collection_scheduled_jobs = "scheduled_jobs"
    collection_user = "user"
    collection_user_project = "user_project"
    collection_scheduled_job_runs = "scheduled_job_runs"


class CommonKeys:
    schedule_id = "schedule_id"
    KEY_WEEKLY = "weekly"
    KEY_MONTHLY = "monthly"
    KEY_YEARLY = "yearly"
    KEY_ONCE = "once"
    KEY_MONTH = "month"
    KEY_HOUR = "hour"
    KEY_DAY = "day"
    KEY_MINUTE = "minute"
    KEY_DAILY = "daily"
    KEY_YEAR = "year"
    KEY_DAY_OF_WEEK = "day_of_week"
    KEY_DAY_OF_MONTH = "day_of_month"
    KEY_MONTH_OF_YEAR = "month_of_year"
    KEY_CRON_DICT = "cron_dict"
    KEY_WEEK = "week"
    KEY_RECURSION_COUNT = "recursion_count"
    KEY_TIMEZONE = "timezone"


class Secrets:
    LOCK_OUT_TIME_MINS = 30
    leeway_in_mins = 10
    unique_key = "45c37939-0f75"
    token = "8674cd1d-2578-4a62-8ab7-d3ee5f9a"
    issuer = "ilens"
    alg = "RS256"
    signature_key = "kliLensKLiLensKL"
    signature_key_alg = ["HS256"]


class APIJobConstants:
    response_codes = {
        "200": dict(status=True, message="Job response for #schedule_id#: #msg#"),
        "210": dict(status=True, message="No response expected from a UDP protocol"),
        "401": dict(
            status=False,
            message="Job faced an authorization issue when accessing the API '#url#': #err#",
        ),
        "403": dict(
            status=False,
            message="Job faced an authentication issue when accessing the API '#url#': #err#",
        ),
        "404": dict(
            status=False,
            message="Job was unable to find the URL '#url#': #err#",
        ),
    }

    validation_failed = "Request data model validation failed!"
    scheduling_failure = "Faced a problem when scheduling the job"
