if __name__ == '__main__':
    from dotenv import load_dotenv

    load_dotenv()
import uvicorn

from main import app
from scripts.constants.app_configuration import Service
from scripts.core.engine.scheduler_engine import scheduler
from scripts.logging.logging import logger

service_obj = Service()
scheduler.start()

if __name__ == "__main__":
    try:
        logger.info("Starting the scheduler framework")
        logger.info("Scheduler framework started successfully")
        uvicorn.run(app, host=service_obj.host, port=int(service_obj.port))
    except (KeyboardInterrupt, SystemExit):
        scheduler.shutdown()
        raise
