# iLens -  DevOps

### GitFlow
Below is the list of branches for which CI/CD is configured.


### Branches
| Branch    | Description                                                               | URL                                              | 
| --------- | ------------------------------------------------------------------------- | -------------------------------------------------------------- | 
| `master`  | Tag and Release the new Version.          |-|
| `QA` | Deploy to Non-production, testing environment - AKS. | https://qa.ilens.io/ | 
| `develop` | Deploy to the 220-Server and Dev-Kubernetes Cluster.                      | http://192.168.0.220/dev_master/ and http://192.168.0.236/dev_master/  |
| `feature/<feature_name>`  | This holds the code base for feature update.          |-|
| `patch/<patch_name>`  | This holds the code base for patch update.          |-|


- There are two environments for Development Team in which, one of them is a self hosted Kubernetes Cluster - http://192.168.0.236/dev_master/  and the other environment where source code is deployed - http://192.168.0.220/dev_master/  . 
- The QA Environment is a AKS Cluster - https://qa.ilens.io/ 
- Production environments are all client environments.

### Merge Requests

1. When a Merge Request is raised that targets `develop` and `QA` branches, pipelines will be triggered for the deployment in the respective environments if the merge is completed.  
1. When a feature update has to be made, a new branch named **`feature/`<feature_name>** has to be created from `master` branch. Once development is completed, the code should be merged back to `master` branch for which auto-tagging will happen.
1. When a patch update has to be made, a new branch named **`patch/`<patch_name>** has to be created from `master` branch. Once development is completed, the code should be merged back to `master` branch for which auto-tagging will happen.

The same is depicted in the below diagram:

<img src="https://gitlab-pm.knowledgelens.com/KnowledgeLens/Products/iLens-2.0/core/devops/scripts/-/raw/auto-tagging-ci/Patch-Feature-Flow.png" alt="Merge request"/>

### Environment
* [ ] MONGO_URI=mongodb://192.168.0.220:2717
* [ ] APP_NAME=ilens_scheduler
* [ ] SCHEDULER_THREAD=120
* [ ] SCHEDULER_PROCESS=20
* [ ] MAX_INSTANCE=200
* [ ] REDIS_URI=redis://192.168.0.220:6379
