import logging
import os
from logging.handlers import RotatingFileHandler


def get_logger():
    """
     Creates a rotating log
     """
    __logger__ = logging.getLogger('')
    __logger__.setLevel("ERROR")
    log_formatter = '%(asctime)s - %(levelname)-6s - [%(threadName)5s:%(funcName)5s():%(lineno)s] - %(message)s'
    time_format = "%Y-%m-%d %H:%M:%S"
    formatter = logging.Formatter(log_formatter, time_format)
    log_files = os.path.join(r"C:\Users\logesh.n\PycharmProjects\site_redis_task\temp\_ERROR.log")
    temp_handler = RotatingFileHandler(log_files, maxBytes=100000000, backupCount=5)
    temp_handler.setFormatter(formatter)

    __logger__.addHandler(temp_handler)

    return __logger__


logger = get_logger()
