import json
from paho.mqtt import client

from scripts.config.app_config import mqtt_username, mqtt_password, mqtt_host, mqtt_port, token
from scripts.config.databases.redis.redis_connection import connection_1, connection_2, connection_3


def connect_mqtt() -> client:
    def on_connect(client, userdata, flags, rc):
        if rc == 0:
            print("Connected to MQTT Broker!", client)
        else:
            print("Failed to connect, return code %d\n", rc)

    mqtt_client = client.Client()
    mqtt_client.username_pw_set(mqtt_username, mqtt_password)
    mqtt_client.on_connect = on_connect
    mqtt_client.connect(mqtt_host, int(mqtt_port))
    return mqtt_client


def subscribe(mqtt_client: client):
    def on_message(client, userdata, msg):
        data = msg.payload.decode()
        data_dict = json.loads(data)
        no = data_dict["site_id"]
        if data_dict["data_quality"] == 0:
            r1 = connection_1.set(no, json.dumps(data_dict))
            print("r1", r1)
        elif data_dict["data_quality"] == 1:
            r2 = connection_2.set(no, json.dumps(data_dict))
            print("r1", r2)
        elif data_dict["data_quality"] == 2:
            r3 = connection_3.set(no, json.dumps(data_dict))
            print("r1", r3)

        print(f"Received `{data_dict}` from `{msg.topic}` topic")

    mqtt_client.subscribe(token)
    mqtt_client.on_message = on_message


def run():
    mqtt_client = connect_mqtt()
    subscribe(mqtt_client)
    mqtt_client.loop_forever()


if __name__ == '__main__':
    run()
