import json
import random
import time
from paho.mqtt import client

from scripts.config.app_config import mqtt_username, mqtt_password, mqtt_host, mqtt_port, token


def connect_mqtt():
    def on_connect(client, userdata, flags, rc):
        if rc == 0:
            print("Connected to MQTT Broker!", client)
        else:
            print("Failed to connect, return code %d\n", rc)

    mqtt_client = client.Client()
    mqtt_client.username_pw_set(mqtt_username, mqtt_password)
    mqtt_client.on_connect = on_connect
    mqtt_client.connect(mqtt_host, int(mqtt_port))
    return mqtt_client


def publish(client):

    while True:
        time.sleep(10)
        data = {"data": {"PM10": random.randint(0, 100),
                         "PM2.5": random.randint(0, 100),
                         "SO2": random.randint(0, 100),
                         "NO2": random.randint(0, 100)},
                "site_id": "site"+str(random.randint(0, 100)),
                "data_quality": random.randint(0, 2)
                }
        data_json = json.dumps(data)
        result = client.publish(token, data_json)
        # result: [0, 1]
        status = result[0]
        if status == 0:
            print(f"Send `{data}` to topic `{token}`")
        else:
            print(f"Failed to send message to topic {token}")


def run():
    mqtt_client = connect_mqtt()
    mqtt_client.loop_start()
    publish(mqtt_client)


if __name__ == '__main__':
    run()
