import json
import random
import time
from paho.mqtt import client

from scripts.config.app_config import mqtt_username, mqtt_password, mqtt_host, mqtt_port, token


def connect_mqtt() -> client:
    def on_connect(client, userdata, flags, rc):
        if rc == 0:
            print("Connected to MQTT Broker!", client)
        else:
            print("Failed to connect, return code %d\n", rc)

    mqtt_client = client.Client()
    mqtt_client.username_pw_set(mqtt_username, mqtt_password)
    mqtt_client.on_connect = on_connect
    mqtt_client.connect(mqtt_host, int(mqtt_port))
    return mqtt_client


def subscribe(mqtt_client: client):
    def on_message(client, userdata, msg):
        data = msg.payload.decode()
        data_dict = json.loads(data)
        print(f"Received `{data_dict}` from `{msg.topic}` topic")

    mqtt_client.subscribe(token)
    mqtt_client.on_message = on_message


def run():
    mqtt_client = connect_mqtt()
    subscribe(mqtt_client)
    mqtt_client.loop_forever()


if __name__ == '__main__':
    run()
