import os
from dotenv import load_dotenv
from scripts.logging.logger import logger

try:
    load_dotenv()
    token = os.getenv("TOKEN")
    mqtt_host = os.getenv("MQTT_HOST")
    mqtt_port = os.getenv("MQTT_PORT")
    mqtt_username = os.getenv("MQTT_USERNAME")
    mqtt_password = os.getenv("MQTT_PASSWORD")
    redis_host = os.getenv("redis_host")
    redis_port = os.getenv("redis_port")

except Exception as e:
    logger.error(e)
    print("Exception occurred in app_config file > ", e)
