from flask import Blueprint
from flask import request
import logging
from scripts.handler.colour_finder_handler import Find_Colour

color_finder = Blueprint('example_blueprint', __name__)

find_colour_object = Find_Colour()

try:
    @color_finder.route('/host', methods=['POST'])
    def post_request():
        content = request.get_json()
        required_data = find_colour_object.find_colour(content)
        return required_data
except Exception:
    logging.info("find colour method is not working")
    raise Exception
