import csv,logging,time


class Mqtt_Publish:
    @staticmethod
    def mqtt_publish(client):
        choice = input("please enter topic you need(kWh/kVAh/kW/kVA/current) :")
        # covert input to lower case
        choice = choice.lower()

        def on_message(client, userdata, message):
            print("message received ", str(message.payload.decode("utf-8")))
            print("message topic=", message.topic)
            print("message qos=", message.qos)
            print("message retain flag=", message.retain)

        client.on_message = on_message
        list_kwh = []
        list_kvah = []
        list_kw = []
        list_kva = []
        list_current = []
        try:
            with open('input.csv', mode='r') as csv_file:
                csv_reader = csv.DictReader(csv_file)

                for row in csv_reader:
                    list_kwh.append({"Timestamp": row["Timestamp"], "Value": row['kWh']})
                    list_kvah.append({"Timestamp": row["Timestamp"], "Value": row['kVAh']})
                    list_kw.append({"Timestamp": row["Timestamp"], "Value": row['kW']})
                    list_kva.append({"Timestamp": row["Timestamp"], "Value": row['kVA']})
                    list_current.append({"Timestamp": row["Timestamp"], "Value": row['current']})
        except Exception :
            logging.exception("Exception occurred in opening of file", exc_info=True)
        client.loop_start()
        if choice == "kwh":
            client.subscribe("Kwh")
        elif choice == "kvah":
            client.subscribe("kVAh")
        elif choice == "kw":
            client.subscribe("kW")
        elif choice == "kva":
            client.subscribe("kVA")
        elif choice == "current":
            client.subscribe("current")
        else:
            print("Invalid Input")
        client.publish("Kwh", str({"Kwh": list_kwh}))
        client.publish("kVAh", str({"KVAh": list_kvah}))
        client.publish("kW", str({"kW": list_kw}))
        client.publish("kVA", str({"kVA": list_kva}))
        client.publish("current", str({"current": list_current}))
        time.sleep(4)
        client.loop_stop()
        # print({"Timestamp":row["Timestamp"],"Kwh":row['kWh']}
