from pymongo import MongoClient


class Mongo_utility:
    @staticmethod
    def display(database_name, collection_name):
        try:
            client = MongoClient('143.110.191.155', 37217)
            database = client[database_name]
            user_details = database[collection_name]
            # Displaying using find()
            records = user_details.find()
            for data_values in records:
                print(data_values)
            # Displaying using find_one()
            print(user_details.find_one())
        except Exception:
            return Exception("Problem in Displaying")

    @staticmethod
    def find(database_name, collection_name, query):
        try:
            client = MongoClient('143.110.191.155', 37217)
            database = client[database_name]
            user_details = database[collection_name]
            return user_details.find(query)
        except Exception:
            return "Problem in Searching"

    @staticmethod
    def update(database_name, collection_name, query):
        try:
            client = MongoClient('143.110.191.155', 37217)
            database = client[database_name]
            user_details = database[collection_name]
            # Updateing one record
            user_details.update(query[0], query[1])
            # we can Update monay records at a time by useing updateMany

        except Exception:
            return "Problem in Updateing"

    @staticmethod
    def delete(database_name, collection_name, query):
        try:
            client = MongoClient('143.110.191.155', 37217)
            database = client[database_name]
            user_details = database[collection_name]
            # delete single query at a time
            user_details.delete_one(query)
            # We can Delete all records by useing (user_details.delete_many({}))
        except Exception:
            return "Problem in deleteing"
