import logging

import bcrypt
from flask import Blueprint
from flask import render_template, request, flash

from scripts.handler.login_handler import Mongobd

blueprint_object = Blueprint('example_blueprint', __name__)

mongodb_object = Mongobd()

try:
    # To open login page
    @blueprint_object.route('/')
    def login():
        return render_template('login.html')


    # To open registration page
    @blueprint_object.route('/registration')
    def registration():
        return render_template('registration.html')


    # To get registration details
    @blueprint_object.route('/registration_data', methods=['POST'])
    def input_values():
        # collecting user details from registration.html
        data = {"Name": request.form["name"], "Phone number": request.form["number"], "Mail id": request.form["mail"],
                "User Id": request.form["user_id"],
                "Password": request.form["password"]}
        if request.form["password"] == request.form["r_password"]:
            # sending data to the database.
            result = mongodb_object.insert(data, request.form["user_id"],request.form["password"])
            if result == 1:
                # works when user is successfully register
                flash("you have successfully register. you can login here :")
                # It redirect to login page after successfully register
                return render_template('login.html')
            else:
                # If user enter the same user Id already exists
                error = "User id already exists"
                # It redirect to registration page along with  error
                return render_template('registration.html', error=error)
        else:
            # If user enter the same user Id already exists
            error = "password and Retype password must be same"
            # It redirect to registration page along with  error
            return render_template('registration.html', error=error)


    # To get login details
    @blueprint_object.route('/login_data', methods=['POST'])
    def required_values():
        # sending the username,password for checking
        result = mongodb_object.find_query(request.form["username"], request.form["pwd"])
        if result == 1:
            # work when login details are correct and redirect to website page
            return render_template('login_success.html')
        elif result == 2:
            # work when user is new to website
            error = "Please enter correct user id. If you are new user first register by clicking below Register button"
            # It redirect to login page along with error
            return render_template('login.html', error=error)
        else:
            # Works when user entered new password
            error = "please enter correct password"
            # It redirect to login page along with error
            return render_template('login.html', error=error)

except Exception as e:
    logging.exception("Exception occurred in connection", exc_info=True)
    print(e)
