import configparser
import logging

config = configparser.ConfigParser()
config.read('database.conf')

db_url = config['DB']['db_url'] or 'localhost'
port = int(config['DB']['port']) or 27017

db_name = config['DB']['database_name']
if db_name == '':
    logging.critical('Database Name empty.')

collection_name = config['DB']['collection_name']
if collection_name == '':
    logging.critical('Collection Name empty.')

site_id = config['SITE']['site_id']
if site_id == '':
    logging.critical('Site id empty.')
