import json
import time
import paho.mqtt.client as mqtt
from scripts.app_constants import DATA_LIST
from scripts.logger import logger


class MQTTSubscriber:
    def __init__(self, source_config):
        self.source_ip = source_config['ip']
        self.source_port = source_config['port']
        self.source_topic = source_config['topic']

    def on_connect(self, rc):
        logger.info("Connected to source with result code {}".format(str(rc)))

    def on_message(self, client, userdata, message):
        try:
            logger.info("data arrived : {}".format(str(time.time())))
            payload = json.loads(message.payload)
            logger.debug("Payload DATA : {}".format(payload["data"]))
            DATA_LIST.append(payload)
        except Exception as es:
            logger.error("Exception in received data : {}".format(str(es)))

    def connect_to_source(self):
        try:
            logger.info("Connecting to {}:{}".format(str(self.source_ip), str(self.source_port)))
            client = mqtt.Client()
            client.on_message = self.on_message
            client.on_connect = self.on_connect
            client.connect(self.source_ip, port=int(self.source_port))
            client.subscribe(self.source_topic)
            client.loop_start()
        except Exception as e:
            logger.exception("Exception when connecting to MQTT:{}".format(str(e)))
