import json
import paho.mqtt.client as paho

from scripts.logger import logger


class MQTTPublisher(object):

    def __init__(self, dest_config):
        """
        Initializer
        """
        self.destination_ip = dest_config["ip"]
        self.destination_port = dest_config["port"]
        self.destination_topic = dest_config["topic"]

    def on_connect(self, rc):
        logger.info("Connected to destination with result code {}".format(str(rc)))

    def connect_to_destination(self):
        try:
            self.mqtt_client = paho.Client()  # create client object
            self.mqtt_client.on_connect = self.on_connect
            logger.debug("Connecting to {}:{}".format(self.destination_ip, str(self.destination_port)))
            res = self.mqtt_client.connect(self.destination_ip, self.destination_port)
            if res != 0:
                logger.exception("MQTT Connection Exception")
        except Exception as e:
            logger.exception("Exception while connecting to MQTT:" + str(e))

    def publish_data(self, message):
        try:
            self.connect_to_destination()
            logger.debug("MQTT Publish to :{}".format(self.destination_topic))
            logger.debug("MQTT DATA : {}".format(str(message)))
            msg_info = self.mqtt_client.publish(self.destination_topic, json.dumps(message), qos=1)
            self.mqtt_client.disconnect()
            if msg_info[0] == 4:
                logger.debug("mqtt connection lost")
                return False
            else:
                logger.info("MQTT Message published successfully")
                return True

        except Exception as e:
            logger.exception("Exception while publishing the message to topic:" + str(e))
            return False
