import logging
import os
from logging.handlers import RotatingFileHandler

from scripts.config_reader import LOGGING_JSON


def get_logger():
    """
     Creates a rotating log
     """
    __logger__ = logging.getLogger('')
    __logger__.setLevel(LOGGING_JSON["level"].upper())
    log_formatter = '%(asctime)s - %(levelname)-6s - [%(threadName)5s:%(funcName)5s():''' \
                      '%(lineno)s] - %(message)s'
    time_format = "%Y-%m-%d %H:%M:%S"
    formatter = logging.Formatter(log_formatter, time_format)
    log_file = os.path.join(LOGGING_JSON["file_path"] + LOGGING_JSON["name"] + '.log')
    if not os.path.exists(LOGGING_JSON["file_path"]):
        os.makedirs(LOGGING_JSON["file_path"])

    temp_handler = RotatingFileHandler(log_file,
                                       maxBytes=LOGGING_JSON["max_bytes"],
                                       backupCount=LOGGING_JSON["back_up_count"])
    temp_handler.setFormatter(formatter)
    __logger__.addHandler(temp_handler)

    return __logger__


logger = get_logger()
