import threading
from scripts.mqtt_subscriber import MQTTSubscriber
from scripts.mqtt_publisher import MQTTPublisher
from scripts.config_reader import getConfig
from scripts.app_constants import DATA_LIST


class myThread(threading.Thread):
    def __init__(self, threadID, path_to_config):
        threading.Thread.__init__(self)
        self.threadID = threadID
        self.thread_config = getConfig(path_to_config)
        self.mapper = self.thread_config['mapper']
        self.mqtt_subs = MQTTSubscriber(self.thread_config['source'])
        self.mqtt_pub = MQTTPublisher(self.thread_config['destination'])

    def run(self):
        self.mqtt_subs.connect_to_source()
        self.mqtt_pub.connect_to_destination()
        while True:
            if len(DATA_LIST) > 0:
                payload_data = DATA_LIST.pop()
                new_data = {}
                for tag in payload_data['data']:
                    if tag in self.mapper:
                        new_data[self.mapper[tag]] = payload_data['data'][tag]
                payload_data["data"] = new_data
                if payload_data["data"]:
                    self.mqtt_pub.publish_data(payload_data)


if __name__ == '__main__':
    t = myThread(1, 'conf/site_203.json')
    t.start()
