from scripts.util.redis_db import previousTag
from scripts.config.json_reader import tags_list
from scripts.constants.tag_constants import prev_tag_data
from scripts.util.logger import logger
import json
import time

redis_db_obj = previousTag()


def get_previous_data():
    logger.info('REDIS')
    current_time = int(time.time()) * 1000
    for tag in tags_list:
        tag_data = redis_db_obj.get_data().mget([tag, tags_list[tag]])
        logger.info(f"{tag} : {tag_data[0]}")
        logger.info(f"{tags_list[tag]} : {tag_data[1]}")
        # print(f"{tag} : {tag_data[0]}")
        # print(f"{tags_list[tag]} : {tag_data[1]}")
        if tag_data[0] is None:
            tag_data[0] = '{"timestamp": ' + str(current_time) + ', "value": 0.0}'
        if tag_data[1] is None:
            tag_data[1] = '{"timestamp": ' + str(current_time) + ', "value": 0.0}'
        tag_data[0] = json.loads(tag_data[0])
        tag_data[1] = json.loads(tag_data[1])

        prev_tag_data[tag] = {
            'previous_value': tag_data[0]['value'],
            'previous_time': tag_data[1]['timestamp'],
            'previous_totalized_value': tag_data[1]['value']
        }
