import json
from scripts.utils.logger import logger

git_json = None
server_json = None


def read_git_json():
    global git_json
    try:
        json_file = open('conf/git.json')
        git_json = json.loads(json_file.read())
    except Exception as es:
        logger.exception(f'Exception while reading git.json : {es}')
    return git_json


def read_server_json():
    global server_json
    try:
        json_file = open('conf/server.json')
        server_json = json.loads(json_file.read())
    except Exception as es:
        logger.exception(f'Exception while reading server.json : {es}')
    return server_json


git_config = read_git_json()
server_config = read_server_json()
