import logging
import os
from logging.handlers import RotatingFileHandler

from scripts.config.config_reader import LOGGING_JSON


def get_logger():
    """
     Creates a rotating log
     """
    if not os.path.exists(LOGGING_JSON["file_path"]):
        os.makedirs(LOGGING_JSON["file_path"])

    __logger__ = logging.getLogger('')
    __logger__.setLevel(LOGGING_JSON["level"].upper())
    log_formatter = '%(asctime)s - %(levelname)-6s - %(message)s'
    time_format = "%Y-%m-%d %H:%M:%S"
    formatter = logging.Formatter(log_formatter, time_format)
    log_file = os.path.join(LOGGING_JSON["file_path"] + LOGGING_JSON["name"] + '.log')

    temp_handler = RotatingFileHandler(log_file,
                                       maxBytes=LOGGING_JSON["max_bytes"],
                                       backupCount=LOGGING_JSON["back_up_count"])
    temp_handler.setFormatter(formatter)
    __logger__.addHandler(temp_handler)

    return __logger__

# import logging.handlers
# from logging.handlers import RotatingFileHandler
#
#
# def get_logger():
#     log_file = os.path.join(LOGGING_JSON["file_path"] + LOGGING_JSON["name"] + '.log')
#     if not os.path.exists(LOGGING_JSON["file_path"]):
#         os.makedirs(LOGGING_JSON["file_path"])
#     __logger__ = logging.getLogger(LOGGING_JSON["name"] + '_Client')
#     __logger__.propagate = False
#     formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s', "%Y-%m-%d %H:%M:%S")
#     __logger__.setLevel(logging.DEBUG)
#
#     handler = RotatingFileHandler(log_file,
#                                   maxBytes=int(LOGGING_JSON["max_bytes"]),
#                                   backupCount=int(LOGGING_JSON["back_up_count"]))
#     handler.setFormatter(formatter)
#     if __logger__.hasHandlers():
#         __logger__.handlers.clear()
#
#     __logger__.addHandler(handler)
#     __logger__.debug('Logger Initialized')
#
#     return __logger__


logger = get_logger()
