from configparser import ConfigParser

config_file_path = r"conf/application.conf"
parser = ConfigParser()
parser.read(config_file_path)


def read_config():
    config_json = dict()
    config_json["file_path"] = parser.get("LOG", "base_path")
    config_json["level"] = parser.get("LOG", "log_level")
    config_json["name"] = parser.get("LOG", "name")
    config_json["max_bytes"] = int(parser.get("LOG", "max_bytes"))
    config_json["back_up_count"] = int(parser.get("LOG", "back_up_count"))

    return config_json


def read_application_config():
    config_json = dict()
    config_json['mqtt'] = {
        "host": parser.get("MQTT", "host"),
        "port": int(parser.get("MQTT", "port")),
        "topic": parser.get("MQTT", "topic"),
    }
    config_json['motor'] = {
        "pin": int(parser.get("MOTOR", "pin")),
        "status_file": parser.get("MOTOR", "status_file")
    }

    config_json['site'] = {
        "tag": parser.get("SITE", "tag")
    }

    return config_json


LOGGING_JSON = read_config()
application_config = read_application_config()
