import RPi.GPIO as GPIO
import time
from scripts.config.config_reader import application_config
from scripts.util.file_util import file_write
from scripts.util.logger import logger


def turn_off():
    pin = int(application_config['motor']['pin'])
    GPIO.setmode(GPIO.BOARD)
    GPIO.setup(pin, GPIO.OUT)
    GPIO.output(pin, GPIO.HIGH)
    file_write(content={"status": "off"})
    logger.info('json file update with off')


def turn_on():
    pin = int(application_config['motor']['pin'])
    GPIO.setmode(GPIO.BOARD)
    GPIO.setup(pin, GPIO.OUT)
    GPIO.output(pin, GPIO.LOW)
    file_write(content={"status": "on"})
    logger.info('json file update with on')
