from scripts.config.json_reader import git_config


class CommonCommands:
    """
    class to get common commands that is platform independent.
    """

    def __init__(self, os, build_type, branch, timestamp):
        """
        initialise commands

        :param os:
        :param build_type:
        :param branch:
        :param timestamp:
        """

        self.os = os
        self.build_type = build_type
        self.branch = branch
        self.timestamp = timestamp
        self.directory = git_config[build_type]['directory'][os]
        # common commands
        self.git_command = f"git clone --branch {git_config[build_type]['branch']} {git_config[build_type]['git']} " \
                           f"{self.directory}{build_type}/" \
                           f"{git_config[build_type]['clone']}{timestamp}"
        self.change_dir = f"cd {self.directory}{build_type}/" \
                          f"{git_config[build_type]['clone']}{timestamp}"
        self.pip = 'pip install -r requirements.txt'
        self.installer = f"pyinstaller {git_config[build_type]['entrypoint']}.py"
        self.build_path = f"{self.directory}{build_type}/{git_config[build_type]['build']}{branch}"

    def get_all_dir(self):
        """
        Module returns all the directory involved in the build.

        :return: dict
        """

        _dir = git_config[self.build_type]['directory'][self.os]
        directory = {
            "main": f"{_dir}",
            "branch": f"{_dir}{self.build_type}",
            "build": f"{_dir}{self.build_type}/"
                     f"{git_config[self.build_type]['build']}",
            "clone": f"{_dir}{self.build_type}/"
                     f"{git_config[self.build_type]['clone']}",
            "backup": f"{_dir}{self.build_type}/"
                      f"{git_config[self.build_type]['backup']}",
        }
        return directory

    @staticmethod
    def cwd():
        return f"cd"


class WindowsCommands(CommonCommands):
    """
    class to get windows commands
    """

    def __init__(self, build_type, branch, timestamp):
        """
        initialise commands.

        :param build_type:
        :param branch:
        :param timestamp:
        """

        # common commands
        CommonCommands.__init__(self, 'windows', build_type, branch, timestamp)

        # windows specific commands
        self.directory = git_config[build_type]['directory']['windows']
        self.backup_dir = git_config[build_type]['backup']
        self.build_dir = git_config[build_type]['build']
        self.environment = f"{git_config[build_type]['environment']['windows']}"
        self.robocopy = f"robocopy {self.directory}{build_type}/" \
                        f"{git_config[build_type]['clone']}{timestamp}/dist/{git_config[build_type]['entrypoint']} " \
                        f"{self.directory}{build_type}/{git_config[build_type]['build']}{branch}/"
        self.remove_dir = f'rmdir /s /q "{self.directory}{build_type}/{self.backup_dir}{branch}"'
        self.backup = f"move {self.directory}{build_type}/{self.build_dir}{branch} {self.directory}{build_type}/backup"
        self.config_copy = f"robocopy {self.directory}{build_type}/{git_config[build_type]['clone']}{timestamp}/conf " \
                           f"{self.directory}{build_type}/{git_config[build_type]['clone']}{timestamp}" \
                           f"/dist/{git_config[build_type]['entrypoint']}/conf/"


class LinuxCommands(CommonCommands):
    """
    Class to get linux commands.
    """

    def __init__(self, build_type, branch, timestamp):
        """
        initialise commands.

        :param build_type:
        :param branch:
        :param timestamp:
        """

        # common commands
        CommonCommands.__init__(self, 'linux', build_type, branch, timestamp)

        # linux specific commands
        self.directory = git_config[build_type]['directory']['linux']
        self.backup_dir = git_config[build_type]['backup']
        self.build_dir = git_config[build_type]['build']
        self.environment = f". {git_config[build_type]['environment']['linux']}"
        self.copy = f"cp -r {self.directory}{build_type}/" \
                    f"{git_config[build_type]['clone']}{timestamp}/dist/{git_config[build_type]['entrypoint']} " \
                    f"{self.directory}{build_type}/{git_config[build_type]['build']}{branch}/"
        self.remove_dir = f'rm -rf "{self.directory}{build_type}/{self.backup_dir}{branch}"'
        self.backup = f"mv {self.directory}{build_type}/{self.build_dir}{branch} {self.directory}{build_type}/backup"
        self.config_copy = f"cp -r {self.directory}{build_type}/{git_config[build_type]['clone']}{timestamp}/conf " \
                           f"{self.directory}{build_type}/{git_config[build_type]['clone']}{timestamp}" \
                           f"/dist/{git_config[build_type]['entrypoint']}/"
