import platform
import time

from scripts.core.build import WindowsBuilder, LinuxBuilder
from scripts.utils.common_utils import file_write, write_build_log
from scripts.utils.logger import logger


def build(channel_data):
    # builder platform
    builder = None
    if platform.system().lower() == 'windows':
        builder = WindowsBuilder(channel_data)

    elif platform.system().lower() == 'linux':
        builder = LinuxBuilder(channel_data)

    # writing current build information
    logger.info(f"channel data : {channel_data}")

    # build execution
    builder.check_directory()

    logger.info(f"Staring build : {time.ctime()}")
    build_info = builder.execute_build()
    logger.info(f"Ended build : {time.ctime()}")

    write_build_log(platform.system().lower(), {"channel_config": channel_data, "build_log": build_info})
