import os
from scripts.utils.logger import logger
from scripts.utils.command import WindowsCommands, LinuxCommands


class WindowsBuilder:
    """
    Windows Builder class
    """

    def __init__(self, channel_config):
        """
        Initialise commands
        """

        self.repository = channel_config['repository']
        self.timestamp = channel_config['timestamp']
        self.branch = channel_config['branch']

        # initialising windows commands
        commands = WindowsCommands(self.repository, self.branch, self.timestamp)

        self.git_command = commands.git_command
        self.change_dir = commands.change_dir
        self.environment = commands.environment
        self.pip = commands.pip
        self.installer = commands.installer
        self.robocopy = commands.robocopy
        self.config_copy = commands.config_copy
        self.backup = commands.backup
        self.remove_dir = commands.remove_dir
        self.directory = commands.get_all_dir()

    def execute_build(self):
        """
        Module to execute windows build commands.

        :return:
        """

        # command for windows build execution
        cmd = f"{self.remove_dir} & {self.backup} & {self.git_command} & {self.change_dir} & {self.environment}.bat &" \
              f"{self.pip} & {self.installer} & {self.config_copy} & {self.robocopy} /E"

        # print('rmdir', self.remove_dir)
        # print('backup', self.backup)
        # print('git', self.git_command)
        # print('cd', self.change_dir)
        # print('env', self.environment)
        # print('req', self.pip)
        # print('installer', self.installer)
        # print('robocopy', self.robocopy)
        # return 1

        # build execution
        build_log = os.popen(cmd).read()
        return build_log

    def check_directory(self):
        """
        Module to check if the directory is present, if not create the directory.

        :return:
        """

        for each_directory in self.directory.values():
            if not os.path.exists(each_directory):
                logger.warn(f"{each_directory} not found. Creating.")
                try:
                    os.mkdir(each_directory)
                except Exception as es:
                    logger.exception(f"Exception in creating {each_directory} : {es}")


class LinuxBuilder:
    """
    Linux Builder Class
    """

    def __init__(self, channel_config):
        """
        Initialise commands
        """

        self.repository = channel_config['repository']
        self.timestamp = channel_config['timestamp']
        self.branch = channel_config['branch']

        # initialising linux commands
        commands = LinuxCommands(self.repository, self.branch, self.timestamp)

        self.git_command = commands.git_command
        self.change_dir = commands.change_dir
        self.environment = commands.environment
        self.pip = commands.pip
        self.installer = commands.installer
        self.copy = commands.copy
        self.backup = commands.backup
        self.remove_dir = commands.remove_dir
        self.directory = commands.get_all_dir()
        self.config_copy = commands.config_copy

    def execute_build(self):
        """
        Module to execute linux build commands.

        :return:
        """

        # commands for linux build execution
        cmd = f"{self.remove_dir} ; {self.backup} ; {self.git_command} ; {self.change_dir} ; {self.environment} && " \
              f"{self.pip} && {self.installer} && {self.config_copy} && {self.copy}"

        # build execution
        build_log = os.popen(cmd).read()
        return build_log

    def check_directory(self):
        """
        Module to check if the directory is present, if not create the directory.

        :return:
        """
        for each_directory in self.directory.values():
            if not os.path.exists(each_directory):
                logger.warn(f"{each_directory} not found. Creating.")
                try:
                    os.mkdir(each_directory)
                except Exception as es:
                    logger.exception(f"Exception in creating {each_directory} : {es}")
