import platform
import uvicorn

from fastapi import FastAPI
from fastapi.middleware.cors import CORSMiddleware

from scripts.core.build_engine_service import build_engine_router
from scripts.config.config_reader import OS_CONFIG

from scripts.utils.logger import logger

app = FastAPI()
origins = [
    "http://build-engine.local.com",
    "https://localhost.tiangolo.com",
    "http://localhost",
    "http://localhost:8000",
]

app.add_middleware(
    CORSMiddleware,
    allow_origins=origins,
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
)
app.include_router(build_engine_router)

if __name__ == '__main__':
    logger.info("********** Starting build-engine **********")
    logger.info(f"Platform : {OS_CONFIG['os']}")

    uvicorn.run(app)
