import json
from typing import Iterator, Dict, Any


class CommonUtils:

    def __init__(self):
        ...

    @staticmethod
    def convert_dict_str_format(input_dict: dict, exclude_keys: str = "label"):
        for k in exclude_keys.split(","):
            input_dict.pop(k, None)
        return_str = json.dumps(input_dict).replace('"', "'")
        for each_key in input_dict:
            return_str = return_str.replace(f"'{each_key}'", each_key)
        return return_str.replace('{', '').replace('}', '')

    @staticmethod
    def process_generator_result(input_data: Iterator[Dict[str, Any]]):
        return_dict = {}
        for _item in input_data:
            if isinstance(_item, dict):
                for k, v in _item.items():
                    if k not in return_dict:
                        return_dict[k] = []
                    return_dict[k].append(v)
        return return_dict
