from scripts.core.engine import GraphTraversal
from scripts.logging import logger
from scripts.schemas import GraphData, GetNodeInfo


class GraphTrackingHandler:
    def __init__(self, db):
        self.graph_traversal = GraphTraversal(db)

    def ingest_data_handler(self, graph_data: GraphData) -> str:
        """
        """
        return self.graph_traversal.ingest_data_handler(graph_data=graph_data)

    def graph_traverse_handler(self, graph_data_request: GetNodeInfo):
        """
        """
        try:
            return self.graph_traversal.fetch_node_data(graph_data_request)
        except Exception as e:
            logger.exception(f"Exception Occurred while fetching the connection details for selected node {e.args}")
            raise
