from typing import Optional

from gqlalchemy import Node, Relationship
from pydantic import Field


class NodeCreationSchema(Node):
    node_id: str = Field()
    node_name: str = Field()
    project_id: str = Field()
    node_properties: Optional[str]


class NodePropertiesSchema(NodeCreationSchema):
    # meta: dict = Field()
    ...


class RelationShipMapper(Relationship, type="Relation_Mapper"):
    project_id: str = Field()

    class Config:
        allow_population_by_field_name = True


class NodeFetchSchema(Node):
    id: str
    project_id: str
