from typing import Optional

from gqlalchemy import Relationship, Node


class Neo4jHandler:
    def __init__(self, db):
        self.db = db

    def delete_relationship_by_id(self, relationship: Relationship) -> Optional[Relationship]:
        results = self.db.execute(
            f"MATCH (start_node)-[relationship: {relationship._type}]->(end_node)"
            f" WHERE id(start_node) = {relationship._start_node_id}"
            f" AND id(end_node) = {relationship._end_node_id}"
            f" AND id(relationship) = {relationship._id}"
            f" DELETE relationship;"
        )

        return results

    def delete_node_by_id(self, node: Node):
        return self.db.execute(
            f"MATCH (node: {node._label}) WHERE {node._get_cypher_fields_and_block('node')} DETACH DELETE node;")

    def execute_custom_query(self, node):
        connection = self.db._get_cached_connection()
