from neo4j.exceptions import ServiceUnavailable

from scripts.db import neo4j_driver
from scripts.logging import logger


class Neo4jConnection:

    def __init__(self):
        try:
            self.__driver = neo4j_driver
        except Exception as e:
            logger.exception(f"Failed to create the driver:{e}")

    def close(self):
        if self.__driver is not None:
            self.__driver.close()

    def query(self, query, parameters=None, db=None):
        assert self.__driver is not None, "Driver not initialized!"
        session = None
        response = None
        try:
            session = self.__driver.session(database=db) if db is not None else self.__driver.session()
            response = list(session.run(query, parameters))
        except Exception as e:
            logger.exception(f"Query failed:{e}")
        finally:
            if session is not None:
                session.close()
        return response

    def create_event_relationship(self, query, db=None, **kwargs):
        assert self.__driver is not None, "Driver not initialized!"
        session = None
        try:
            session = self.__driver.session(database=db) if db is not None else self.__driver.session()
            result = session.write_transaction(
                self._execute_relationship, query, **kwargs)
            # for record in result:
            #     print("Created friendship between: {p1}, {p2}".format(
            #         p1=record['p1'], p2=record['p2']))
        except Exception as e:
            logger.exception(f"Query failed:{e}")
        finally:
            if session is not None:
                session.close()

    @staticmethod
    def _execute_relationship(tx, query, **kwargs):

        # To learn more about the Cypher syntax,
        # see https://neo4j.com/docs/cypher-manual/current/

        # The Reference Card is also a good resource for keywords,
        # see https://neo4j.com/docs/cypher-refcard/current/

        result = tx.run(query, **kwargs)
        try:
            return result
        # Capture any errors along with the query and data for traceability
        except ServiceUnavailable as exception:
            logger.exception("{query} raised an error: \n {exception}".format(
                query=query, exception=exception))
            raise
