from typing import Optional

from gqlalchemy import Node, Relationship
from pydantic import Field


class NodeCreationSchema(Node):
    id: str = Field()
    name: str = Field()


class RelationShipMapper(Relationship, type="Relation_Mapper"):
    date: Optional[str] = Field()

    class Config:
        allow_population_by_field_name = True
