from typing import List

from scripts.db.models import NodeCreationSchema, RelationShipMapper
from scripts.logging import logger
from scripts.schemas import GraphData, NodeSchemaValidation


class GraphTraversal:
    def __init__(self, db):
        """
        Graph Tracking Handler class interacts with the Graph Traversal class
        that fetches all the nodes and relations
        based on the input received from the user
        """
        self.db = db

    def ingest_data_handler(self, graph_data: GraphData):
        try:
            node_list = []
            relations = []
            for node_type, node_obj in graph_data.__root__.items():
                process_dict = NodeSchemaValidation(**node_obj.dict(), label=node_type)
                # if node_obj.action == NodeActionOptions.delete:
                #     pass
                # else:
                self.save_single_node(
                    node_data=NodeCreationSchema(name=process_dict.name, id=f'{process_dict.node_id}',
                                                 properties=process_dict.properties,
                                                 labels=process_dict.label))



        except Exception as e:
            logger.exception(f'Exception occurred while performing data insert/delete functionality {e.args}')
            raise

    def save_single_node(self, node_data: NodeCreationSchema, upsert=False):
        try:
            res = self.load_data_from_graph({"id": node_data.id})
            if upsert and existing_response.id:
                res = self.db.save_node_with_id(node_data, _id=existing_response.id)
            else:
                res = self.db.save_node(node_data)
            print(res)
        except Exception as e:
            logger.exception(f'Exception occurred while creating node for the graph {e.args}')
            raise

    def save_multiple_nodes(self, node_data: List[NodeCreationSchema]):
        try:
            res = self.db.save_nodes(nodes=node_data)
        except Exception as e:
            logger.exception(f'Exception occurred while creating node for the graph {e.args}')
            raise

    def save_relationship(self, rel_data: RelationShipMapper):
        try:
            res = self.db.save_relationship_with_id(rel_data)
            if not res:
                self.db.save_relationship(rel_data)
        except Exception as e:
            logger.exception(f'Exception occurred while creating node for the graph {e.args}')
            raise

    def save_multiple_relationship(self, rel_data: List[RelationShipMapper]):
        try:
            res = self.db.save_relationships(relationships=rel_data)
        except Exception as e:
            logger.exception(f'Exception occurred while creating node for the graph {e.args}')
            raise

    def load_data_from_graph(self, **kwargs):
        try:
            res = self.db.load_node_with_id(kwargs)
            print(res)
        except Exception as e:
            logger.exception(f'Exception Occurred while fetching the node data by {key_name} & {key_value} {e.args}')
            raise
