from typing import Optional

from gqlalchemy import Node, Relationship
from pydantic import Field


class NodeCreationSchema(Node):
    id: str = Field()
    name: str = Field()
    project_id: str = Field()


class NodePropertiesSchema(NodeCreationSchema):
    # meta: dict = Field()
    ...


class RelationShipMapper(Relationship, type="Relation_Mapper"):
    project_id: str = Field()

    class Config:
        allow_population_by_field_name = True


class NodeFetchSchema(Node):
    id: Optional[str]
    name: Optional[str]
    project_id: str
