import os
import sys
from configparser import BasicInterpolation, ConfigParser


class EnvInterpolation(BasicInterpolation):
    """
    Interpolation which expands environment variables in values.
    """

    def before_get(self, parser, section, option, value, defaults):
        value = super().before_get(parser, section, option, value, defaults)

        if not os.path.expandvars(value).startswith('$'):
            return os.path.expandvars(value)
        else:
            return


try:
    config = ConfigParser(interpolation=EnvInterpolation())
    config.read("conf/application.conf")
except Exception as e:
    print(f"Error while loading the config: {e}")
    print("Failed to Load Configuration. Exiting!!!")
    sys.stdout.flush()
    sys.exit()


class Service:
    port = config["SERVICE"]["port"]
    host = config["SERVICE"]["host"]


class DBConf:
    GRAPH_HOST = config.get('GRAPH_DB', 'GRAPH_HOST')
    GRAPH_PORT = config.get('GRAPH_DB', 'GRAPH_PORT')
    GRAPH_USERNAME = config.get('GRAPH_DB', 'GRAPH_USERNAME')
    GRAPH_PASSWORD = config.get('GRAPH_DB', 'GRAPH_PASSWORD')
    GRAPH_DB_TYPE = config.get('GRAPH_DB', 'DB_TYPE')
    if not GRAPH_DB_TYPE:
        GRAPH_DB_TYPE = "neo4j"


class Logging:
    level = config.get("LOGGING", "level", fallback="DEBUG")
    level = level or "INFO"
    tb_flag = config.getboolean("LOGGING", "traceback", fallback=True)
    tb_flag = tb_flag if tb_flag is not None else True
